#!/bin/sh
#
# vddos - this script starts and stops the vddos daemon
#
# chkconfig:   - 85 15
# description:  vDDoS is an HTTP(S) DDoS Protection Reverse Proxy
# processname: vddos
# config:      /vddos/vddos.conf
# pidfile:     /var/run/vddos.pid
# user:        vddos
# Source function library.
. /etc/rc.d/init.d/functions
# Source networking configuration.
. /etc/sysconfig/network
# Check that networking is up.
[ "$NETWORKING" = "no" ] && exit 0
vddos="/vddos/vddos"
prog=$(basename $vddos)
vddos_CONF_FILE="/vddos/vddos.conf"
lockfile=/var/run/vddos.lock
start() {
[ -x $vddos ] || exit 5
[ -f $vddos_CONF_FILE ] || exit 6
echo -n $"Starting $prog: "
daemon $vddos -c $vddos_CONF_FILE
retval=$?
echo
[ $retval -eq 0 ] && touch $lockfile
return $retval
}
stop() {
echo -n $"Stopping $prog: "
killproc $prog -QUIT
retval=$?
echo
[ $retval -eq 0 ] && rm -f $lockfile
return $retval
}
restart() {
configtest || return $?
stop
start
}
reload() {
configtest || return $?
echo -n $"Reloading $prog: "
killproc $vddos -HUP
RETVAL=$?
echo
}
force_reload() {
restart
}
configtest() {
$vddos -t -c $vddos_CONF_FILE
}
rh_status() {
status $prog
}
rh_status_q() {
rh_status  >/dev/null 2>&1
}
case "$1" in
start)
rh_status_q && exit 0
$1
;;
stop)
rh_status_q || exit 0
$1
;;
restart|configtest)
$1
;;
reload)
rh_status_q || exit 7
$1
;;
force-reload)
force_reload
;;
status)
rh_status
;;
condrestart|try-restart)
rh_status_q || exit 0
;;
*)
echo $"Usage: $0 {start|stop|status|restart|condrestart|try-restart|reload|force-reload|configtest}"
exit 2
esac
